/******************************************************************************
 * Public header file for main.c
 * 
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2011 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
*******************************************************************************/

/******************************************************************************
*
* Includes
*
******************************************************************************/
#include "FunctionLib.h"
#include "SMAC_Interface.h"


#define HYPERTERMINAL                        (4)
#define FREESCALE_LABVIEW_SENSOR_GUI         (5)
#define NO_SELECTION_HERE                    (6)


/**************************************************************************************
***************************************************************************************
*                         DEMO CONFIGURATION                                          *
*  RF carrier frequency: select below the RF carrier frequency.                       * 
*  Data output: Select below to watch the frames with the Frescale LabVIEW Sensor GUI *
*               or the hyperterminal. This choice can be done here or in the FXTH87   *
*               emitter project.                                                      *
*  Addresses: Choose the values of the node and broadcast addresses.                  *
*             Frames with an address byte different from one of these two values will *
*             be discarded on the MKW01 side                                          *
*                                                                                     *
***************************************************************************************
***************************************************************************************/

/* Uncomment one of the defines */
#define CARRIER_FREQ 315                                   /* for a 315Mhz carrier frequency */
//#define CARRIER_FREQ 434                                 /* for a 434MHz carrier frequency */
//#define CARRIER_FREQ 915                                 /* for a 915MHz carrier frequency */

/* Uncomment one of the defines */
#define FRAME_DISPLAY HYPERTERMINAL                          /* To use the hyperterminal */
//#define FRAME_DISPLAY FREESCALE_LABVIEW_SENSOR_GUI           /* To use the Freescale LabVIEW Sensor GUI */
//#define FRAME_DISPLAY NO_SELECTION_HERE                      /* The selection is done in the FXTH87 emitter project */


/* Choose the value of the MKW01 node and broadcast addresses */
#define NODE_ADDRESS 0xF0
#define BROADCAST_ADDRESS 0xFF




/******************************************************************************
*
* Public functions
*
******************************************************************************/
void UartTxCallBack(uint8_t *pBuf);

uint16_t Calculate_CRC_FXTH(uint8_t* pu8Buffer, uint16_t u16BufferSize, uint16_t u16Remainder);
uint8_t Checksum_Verification(void);
uint8_t FXTH_CRC_Verification(void);
uint8_t MKW01_CRC_Verification(void);
uint8_t Frame_Verification(void);


